
generate_bodhi_applications_report() {
    local output_folder=$1
    local output_file=$2

    mkdir -p "${output_folder}/log" "${output_folder}/configuration/bodhi"

    echo "====================================================================" >> "${output_file}"
    echo "Bodhi Applications Info" >> "${output_file}"
    echo "-----------------------" >> "${output_file}"

    if [[ -d "/bodhi" ]]; then
      echo "/bodhi folder disk space usage [du -sh]:" >> "${output_file}"
      du -sh /bodhi >> "${output_file}"
      echo "" >> "${output_file}"
    fi

   if [[ -d "/bodhi/installs/current" ]]; then
      echo "/bodhi/installs/current folder disk space usage [du -sh]:" >> "${output_file}"
      du -sh /bodhi/installs/current >> "${output_file}"
      echo "" >> "${output_file}"

      echo "all /bodhi/installs/current files with disk space usage:" >> "${output_file}"
      find /bodhi/installs/current -type f -exec ls -lh {} \; >> "${output_file}"
      echo "" >> "${output_file}"
    fi

   if [[ -d "/bodhi/run/current" ]]; then
      echo "/bodhi/run/current folder disk space usage [du -sh]:" >> "${output_file}"
      du -sh /bodhi/run/current >> "${output_file}"
      echo "" >> "${output_file}"
    fi

   if [[ -d "/bodhi/run/current/bodhi-dotnet" ]]; then
      echo "/bodhi/run/current/bodhi-dotnet folder disk space usage [du -sh]:" >> "${output_file}"
      du -sh /bodhi/run/current/bodhi-dotnet >> "${output_file}"
      echo "" >> "${output_file}"
    fi

   if [[ -d "/bodhi/run/current/bodhi-ui" ]]; then
      echo "/bodhi/run/current/bodhi-ui folder disk space usage [du -sh]:" >> "${output_file}"
      du -sh /bodhi/run/current/bodhi-ui >> "${output_file}"
      echo "" >> "${output_file}"
    fi

   if [[ -d "/bodhi/run/current/bodhi-api" ]]; then
      echo "/bodhi/run/current/bodhi-api folder disk space usage [du -sh]:" >> "${output_file}"
      du -sh /bodhi/run/current/bodhi-api >> "${output_file}"
      echo "" >> "${output_file}"
    fi

   if [[ -d "/bodhi/run/current/control" ]]; then
      echo "/bodhi/run/current/control folder disk space usage [du -sh]:" >> "${output_file}"
      du -sh /bodhi/run/current/control >> "${output_file}"
      echo "" >> "${output_file}"
    fi

    local bodhi_apps_dotnet_folder="/bodhi/run/current/apps/bodhi-dotnet"
    local bodhi_ui_folder="/bodhi/run/current/apps/bodhi-ui"
    local bodhi_api_nodejs_folder="/bodhi/run/current/apps/bodhi-api"
    local bodhi_control_dotnet_folder="/bodhi/run/current/control/bodhi-dotnet"
    echo "please see the configuration files attached to this report in the './configuration/bodhi' folder" >> "${output_file}"
    if [[ -d "${bodhi_apps_dotnet_folder}" ]]; then
      find "${bodhi_apps_dotnet_folder}"  -type f -name "*.json" -exec cp --parents {} "${output_folder}/configuration" \;
      echo "" >> "${output_file}"
    fi
    if [[ -d "${bodhi_control_dotnet_folder}" ]]; then
      find "${bodhi_control_dotnet_folder}"  -type f -name "*.json" -exec cp --parents {} "${output_folder}/configuration" \;
      echo "" >> "${output_file}"
    fi
    if [[ -d "${bodhi_ui_folder}" ]]; then
      mkdir -p "${output_folder}/configuration/${bodhi_ui_folder}"
      cp "${bodhi_ui_folder}/config.js" "${output_folder}/configuration/${bodhi_ui_folder}/config.js"
    fi
    if [[ -d "${bodhi_api_nodejs_folder}" ]]; then
      mkdir -p "${output_folder}/configuration/${bodhi_api_nodejs_folder}"
      cp "${bodhi_api_nodejs_folder}/.env" "${output_folder}/configuration/${bodhi_api_nodejs_folder}/.env"
    fi

    if [[ -d "${bodhi_folder_logs}" ]]; then
      echo "${bodhi_folder_logs} folder disk space usage [du -sh]:" >> "${output_file}"
      du -sh ${bodhi_folder_logs} >> "${output_file}"
      echo "" >> "${output_file}"

      echo "all ${bodhi_folder_logs} files with disk space usage:" >> "${output_file}"
      find ${bodhi_folder_logs} -type f -exec ls -lh {} \; >> "${output_file}"
      echo "please see the log files attached to this report in the './log' folder" >> "${output_file}"
      echo "" >> "${output_file}"

      cp -a ${bodhi_folder_logs} "${output_folder}/log/bodhi"
    fi

    echo "" >> "${output_file}"
    echo "====================================================================" >> "${output_file}"
    echo "" >> "${output_file}"
}


generate_pyrunner_report() {
    local output_folder=$1
    local output_file=$2

    mkdir -p "${output_folder}/log/pyrunner" "${output_folder}/configuration/pyrunner"

    echo "====================================================================" >> "${output_file}"
    echo "PyRunner Info" >> "${output_file}"
    echo "-------------" >> "${output_file}"

    # we cannot really use USER_NAME since pyrunner could be running under a different user: find it
    local pyrunner_user=""
    for user in /home/*; do
        if [[ -d "$user" ]] && [[ -d "$user/pyrunner" ]] && [[ -f "$user/pyrunner/lib/python3.11/site-packages/PyRunner/config/HAL.cfg" ]]; then
            pyrunner_user="$(basename "$user")"
            break
        fi
    done

    # If no user found, default to 'operator'
    if [[ -z "$pyrunner_user" ]]; then
        pyrunner_user="operator"
    fi

    # Check if the determined user has the pyrunner directory structure
    if [[ ! -d "/home/${pyrunner_user}/pyrunner" ]]; then 
        echo "ERROR: failed to find a PyRunner installation for user: ${pyrunner_user} in /home/${pyrunner_user}" >> "${output_file}"
        echo "" >> "${output_file}"
        return 1;
    fi

    echo "PyRunner is running under the user: ${pyrunner_user} in /home/${pyrunner_user}" >> "${output_file}"
    echo "" >> "${output_file}"

    local hal_config_file="/home/${pyrunner_user}/pyrunner/lib/python3.11/site-packages/PyRunner/config/HAL.cfg"
    if [[ -f "${hal_config_file}" ]]; then
        echo "PyRunner version:" >> "${output_file}"
        sed -n -e 's/^\s*Version\s*=\s*//p' "${hal_config_file}" >> "${output_file}"
        echo "" >> "${output_file}"

        echo "Instrument Serial number:" >> "${output_file}"
        sed -n -e 's/^\s*SerNo\s*=\s*//p' "${hal_config_file}" >> "${output_file}"
        echo "" >> "${output_file}"

        echo "please see the pyrunner configuration file HAL.cfg in './configuration/pyrunner'" >> "${output_file}"
        cp -f "${hal_config_file}" "${output_folder}/configuration/pyrunner"
        echo "" >> "${output_file}"
    else
        echo "ERROR: failed to find a PyRunner config/HAL.cfg, missing file ${hal_config_file}" >> "${output_file}"
        echo "" >> "${output_file}"
    fi

    local pyrunner_folder="/home/${pyrunner_user}/pyrunner"
    if [[ -d "${pyrunner_folder}" ]]; then
        echo "${pyrunner_folder} folder disk space usage [du -sh]:" >> "${output_file}"
        du -sh "${pyrunner_folder}" >> "${output_file}"
        echo "" >> "${output_file}"
    fi

    local pyrunner_logs_folder="/home/${pyrunner_user}/logs"
    if [[ -d "${pyrunner_logs_folder}" ]]; then
        echo "${pyrunner_logs_folder} folder disk space usage [du -sh]:" >> "${output_file}"
        du -sh "${pyrunner_logs_folder}" >> "${output_file}"
        echo "" >> "${output_file}"

        echo "all ${pyrunner_logs_folder} files with disk space usage:" >> "${output_file}"
        find ${pyrunner_logs_folder} -type f -exec ls -lh {} \; >> "${output_file}"
        echo "please see the log files attached to this report in the './log' folder" >> "${output_file}"
        echo "" >> "${output_file}"

        cp -a "${pyrunner_logs_folder}" "${output_folder}/log/pyrunner"
    fi

    echo "" >> "${output_file}"
    echo "====================================================================" >> "${output_file}"
    echo "" >> "${output_file}"
}

