
update_applications_settings() {
  local base=$1
  local from=$2
  local to=$3

  if [[ "$from" != "" ]] && [[ "$to" != "" ]] && [[ "$from" != "$to" ]]; then

    if [[ "$FRAMEWORK_LANGUAGE" == "nodejs" ]]; then
      files=(
        "apps/bodhi-api/.env"
        "apps/bodhi-ui/config.js" 
      )
    fi

    if [[ "$FRAMEWORK_LANGUAGE" == "dotnet" ]]; then
      files=(
        "apps/bodhi-dotnet/api/appsettings.Production.json"
        "apps/bodhi-dotnet/ui/appsettings.Production.json"
        "apps/bodhi-dotnet/ws/appsettings.Production.json"
        "apps/bodhi-dotnet/auth/appsettings.Production.json"
        "apps/bodhi-ui/config.js"
        "control/bodhi-dotnet/control/appsettings.Production.json"
      )
    fi

    for file in "${files[@]}"; do
      if [[ -f "${base}/${file}" ]]; then
        echo "    replacing ${from} with ${to} in ${base}/${file}..."
        sed -i "s|${from}|${to}|g" "${base}/${file}"
      fi
      done
  fi
}

update_current_host_public_name() {
  if [[ "${HOST_PUBLIC_NAME}" != "" ]]; then
    # if HOST_PUBLIC_NAME was passed as parameter
    # replace the current one
    local CURRENT_HOST_PUBLIC_NAME=""
    local host_public_name_file="${bodhi_folder_run}/current/${host_public_name_file_name}"
    if [[ -f "${host_public_name_file}" ]]; then
      CURRENT_HOST_PUBLIC_NAME=$(cat "$host_public_name_file" | tr -d '\n')
    fi
    if [[ "${CURRENT_HOST_PUBLIC_NAME}" != "" ]] && [[ "${CURRENT_HOST_PUBLIC_NAME}" != "${HOST_PUBLIC_NAME}" ]]; then
      update_applications_settings "${bodhi_folder_run}/current" "${CURRENT_HOST_PUBLIC_NAME}" "${HOST_PUBLIC_NAME}"
      echo -n ${HOST_PUBLIC_NAME} > "${host_public_name_file}"
    fi
  fi
}

update_next_host_public_name() {
  if [[ "${HOST_PUBLIC_NAME}" != "" ]]; then
    # if  HOST_PUBLIC_NAME was passed as parameter
    echo " update host public name"
    update_applications_settings "${bodhi_folder_run}/next" "${build_host_public_name}" "${HOST_PUBLIC_NAME}"
  fi
}
