delete_all() {

  initial_dir=$(pwd)
  cd /tmp

  stop_services
 
  delete_database $bodhi_db_name
  delete_database $bodhi_idp_db_name

  if [[ -f ${bodhi_control_initd} ]]; then
      echo "  bodhi-control service file ${bodhi_control_initd} exists, delete it..."
      rm -f ${bodhi_control_initd}
      systemctl daemon-reload
  fi

  if [[ -f ${bodhi_apps_initd} ]]; then
      echo "  bodhi-apps service file ${bodhi_apps_initd} exists, delete it..."
      rm -f ${bodhi_apps_initd}
      systemctl daemon-reload
  fi

  if [[ -f "${nginx_conf}/nginx.conf" ]]; then
      echo "  nginx ${nginx_conf}/nginx.conf exists, delete it..."
      rm -f "${nginx_conf}/nginx.conf"
  fi

  if [[ -d "${nginx_conf}/conf.d/bodhi" ]]; then
      echo "  nginx ${nginx_conf}/conf.d/bodhi exists, delete it..."
      rm -rf "${nginx_conf}/conf.d/bodhi"
  fi

  if [[ -d ${bodhi_folder} ]]; then
    echo "  the ${bodhi_folder} folder exists, delete it..."
    rm -rf "${bodhi_folder}"
  fi

  if [[ -d ${bodhi_folder} ]]; then
    echo "  the ${bodhi_folder} folder exists, delete it..."
    rm -rf "${bodhi_folder}"
  fi

  if [[ -d "${bodhi_folder_logs}" ]]; then
    echo "  the ${bodhi_folder_logs} folder exists, delete it..."
    rm -rf "${bodhi_folder_logs}"
  fi

  local old_bodhi_apps_sh_1="/usr/local/bin/bodhi-apps.sh"
  if [[ -f ${old_bodhi_apps_sh_1} ]]; then
    echo "  the ${old_bodhi_apps_sh_1} exists, delete it..."
    rm -f ${old_bodhi_apps_sh_1}
  fi

  local old_tmp_bodhi_apps_sh_2="/tmp/bodhi-apps.sh"
  if [[ -f ${old_tmp_bodhi_apps_sh_2} ]]; then
    echo "  the ${old_tmp_bodhi_apps_sh_2} exists, delete it..."
    rm -f ${old_tmp_bodhi_apps_sh_2}
  fi
  
  if [[ -f "/etc/profile.d/chkwho.sh" ]]; then
    echo "  the /etc/profile.d/chkwho.sh exists, delete it..."
    rm -f "/etc/profile.d/chkwho.sh"
  fi

  if ! remove_pyrunner \
    target_user="operator" \
    pyrunner_systemd="/etc/systemd/system/pyrunner.service" \
    django_systemd="/etc/systemd/system/django.service" \
    chownwdog_systemd="/etc/systemd/system/chownwdog.service"; then
    echo " WARNING: PyRunner removal failed, continuing..."
  fi

  if [[ -d ${tmp_bodhi_folder} ]]; then
    echo "  the ${tmp_bodhi_folder} folder exists, delete it..."
    rm -rf "${tmp_bodhi_folder}"
  fi
  
  if [[ -d "${initial_dir}" ]]; then
    cd $initial_dir
  fi
}
