install_applications() {

  
  echo "install applications : will stop the services, install the applications, and start back the services"
  echo "installation started at $(date)"
  echo ""
  
  local python_version="python3.11"

  if [[ ! -d "${tmp_bodhi_folder_software_updates}" ]]; then
    echo " ERROR: folder not found: $tmp_bodhi_folder_software_updates!"
    exit 1 # yes, we exit the script here
  fi

  if [[ "$INSTALL_APPLICATIONS" == "yes" ]]; then
    if [[ ! -d "${tmp_bodhi_folder_software_updates}/apps" ]]; then
      echo " ERROR: folder not found: $tmp_bodhi_folder_software_updates/apps !"
      exit 1 # yes, we exit the script here
    fi

    if [[ ! -d "${tmp_bodhi_folder_software_updates}/scripts" ]]; then
      echo " ERROR: folder not found: $tmp_bodhi_folder_software_updates/scripts !"
      exit 1 # yes, we exit the script here
    fi
  fi

  echo " package filename: $INSTALL_APPLICATIONS_FILENAME"
  local install_filepath="${tmp_bodhi_folder_software_updates}/apps/${INSTALL_APPLICATIONS_FILENAME}"

  if [[ ! -f "${install_filepath}" ]]; then
    echo " ERROR: file not found: $install_filepath !"
    exit 1 # yes, we exit the script here
  fi

  initial_dir=$(pwd)
  cd "${tmp_bodhi_folder_software_updates}"

  # this script
  local tmp_bodhi_apps_sh="${tmp_bodhi_folder_software_updates}/scripts/bodhi-apps.sh"

  if [[ "${HOST_PUBLIC_NAME}" == "" ]]; then
    # if no HOST_PUBLIC_NAME was passed as parameter
    # use the current one
    if [[ -f "${host_public_name_file}" ]]; then
      HOST_PUBLIC_NAME=$(cat "$host_public_name_file" | tr -d '\n')
    else
      # in 'current' we have an older install that did not write the host_public_name_file
      HOST_PUBLIC_NAME=$(hostname -I | awk '{print $1}')
    fi
  fi

  mkdir -p "${bodhi_folder_installs}/next" "${bodhi_folder_installs}/current" "${bodhi_folder_installs}/previous"

  if [[ "$INSTALL_APPLICATIONS" == "yes" ]]; then
    if [[ "$FRAMEWORK_LANGUAGE" == "nodejs" ]]; then
      sed -i 's|FRAMEWORK_LANGUAGE="dotnet"|FRAMEWORK_LANGUAGE="nodejs"|g' "${tmp_bodhi_apps_sh}"
    fi
    if [[ "$FRAMEWORK_LANGUAGE" == "dotnet" ]]; then
      sed -i 's|FRAMEWORK_LANGUAGE="nodejs"|FRAMEWORK_LANGUAGE="dotnet"|g' "${tmp_bodhi_apps_sh}"
    fi
    if [[ -d "${bodhi_folder_installs}/next/apps" ]]; then
      rm -r -f "${bodhi_folder_installs}/next/apps"
    fi
    if [[ -d "${tmp_bodhi_folder_software_updates}/apps" ]]; then
      mv -f "${tmp_bodhi_folder_software_updates}/apps" "${bodhi_folder_installs}/next/apps"
    fi

    if [[ -d "${bodhi_folder_installs}/next/scripts" ]]; then
      rm -r -f "${bodhi_folder_installs}/next/scripts"
    fi
    if [[ -d "${tmp_bodhi_folder_software_updates}/scripts" ]]; then
      mv -f "${tmp_bodhi_folder_software_updates}/scripts" "${bodhi_folder_installs}/next/scripts"
    fi
  fi

  if [[ "$INSTALL_PYRUNNER" == "yes" ]]; then
    if [[ -d "${bodhi_folder_installs}/next/pyrunner" ]]; then
      rm -r -f "${bodhi_folder_installs}/next/pyrunner"
    fi
    if [[ -d "${tmp_bodhi_folder_software_updates}/pyrunner" ]]; then
      mv -f "${tmp_bodhi_folder_software_updates}/pyrunner" "${bodhi_folder_installs}/next/pyrunner"
    fi
  fi

  # unzip to current dir, the result is the ./apps dir
  # then validate the install
  echo "    unzipping package..."
  unzip -qq "${bodhi_folder_installs}/next/apps/${INSTALL_APPLICATIONS_FILENAME}" -d . 

  # free some space
  rm -f "${bodhi_folder_installs}/next/apps/${INSTALL_APPLICATIONS_FILENAME}"

  # Pyrunner options
  local inventory=""
  local is_simulation="false"
  local is_develop="false"
  local is_prototyping="false"
  local device_ip=""
  local flash_fw_flags=""
  local force_flash_fw_flags=""
  local allow_pyrunner_overwrite="false"
  local pyrunner_user=""
  local pyrunner_user_group="pi"  # hardcoded as per original pascal installer logic

  if [[ "$INSTALL_PYRUNNER" == "yes" ]]; then

    for user in /home/*; do
      if [[ -d "$user" ]] && [[ -d "$user/pyrunner" ]] && [[ -f "$user/pyrunner/lib/${python_version}/site-packages/PyRunner/config/HAL.cfg" ]]; then
        pyrunner_user="$(basename "$user")"
        break
      fi
    done
  
    # If no user found, default to 'operator'
    if [[ -z "$pyrunner_user" ]]; then
      pyrunner_user="operator"
    fi

    inventory=$(get_option_from_options "INVENTORY" "$PYRUNNER_INSTALL_OPTIONS")
    if [[ "$inventory" == "none" ]]; then
      # specified as no inventory
      inventory=""
    else
      if [[ "$inventory" == "false" ]] || [[ "$inventory" == "default" ]]; then
        # 'default' or no INVENTORY in PYRUNNER_INSTALL_OPTIONS: use the default
        inventory=""
      fi

      if [[ -z "$inventory" ]]; then
        # we use the defaults
        # try to read it from the HAL.cfg file if there was a previous installation
        local current_pyrunner_pack_config_HAL="/home/$pyrunner_user/pyrunner/lib/${python_version}/site-packages/PyRunner/config/HAL.cfg"
        if [[ -f "$current_pyrunner_pack_config_HAL" ]]; then
          local current_inventory=$(get_ini_value "Inventory" "Instrument" "$current_pyrunner_pack_config_HAL" 2>/dev/null || echo "")
          inventory="${current_inventory}"
        else
          # default
          inventory="FIBottom"
        fi
      fi
    fi

    is_simulation=$(get_option_from_options "RPISIMULATION" "$PYRUNNER_INSTALL_OPTIONS")
    if [[ "$is_simulation" == "" ]]; then
      is_simulation=$(get_option_from_options "SIMULATION" "$PYRUNNER_INSTALL_OPTIONS")
      if [[ "$is_simulation" == "" ]]; then
        is_simulation=$(get_option_from_options "DEMO" "$PYRUNNER_INSTALL_OPTIONS")
      fi
    fi
    # Validate boolean value and normalize to true/false
    if [[ "$is_simulation" != "true" && "$is_simulation" != "false" ]]; then
      is_simulation=""
    fi
    if [[ "$is_simulation" == "" ]]; then
      # check if there was a previous install with 'simulation'
      if [[ -f ${pyrunner_systemd} ]]; then
        exec_start=$(get_ini_value "ExecStart" "Service" "$pyrunner_systemd" 2>/dev/null || echo "")
        if [[ -n "$exec_start" ]] && [[ "$exec_start" == *"--simulation"* ]]; then
          is_simulation="true"
        else
          is_simulation="false"
        fi
      else
        is_simulation="false"
      fi
    fi

    is_develop=$(get_option_from_options "DEVELOPMENT" "$PYRUNNER_INSTALL_OPTIONS")
    if [[ "$is_develop" == "" ]]; then
      is_develop=$(get_option_from_options "DEVELOP" "$PYRUNNER_INSTALL_OPTIONS")
    fi
    # Validate boolean value and normalize to true/false
    if [[ "$is_develop" != "true" && "$is_develop" != "false" ]]; then
      is_develop=""
    fi
    if [[ "$is_develop" == "" ]]; then
      # check if there was a previous install with 'development'
      if [[ -f ${pyrunner_systemd} ]]; then
        exec_start=$(get_ini_value "ExecStart" "Service" "$pyrunner_systemd" 2>/dev/null || echo "")
        if [[ -n "$exec_start" ]] && [[ "$exec_start" == *"--groundcontrol"* ]]; then
          is_develop="true"
        else
          is_develop="false"
        fi
      else
        is_develop="false"
      fi
    fi

    is_prototyping=$(get_option_from_options "PROTOTYPING" "$PYRUNNER_INSTALL_OPTIONS")
    if [[ "$is_prototyping" == "" ]]; then
      is_prototyping=$(get_option_from_options "PROTOTYPE" "$PYRUNNER_INSTALL_OPTIONS")
    fi
    # Validate boolean value and normalize to true/false
    if [[ "$is_prototyping" != "true" && "$is_prototyping" != "false" ]]; then
      is_prototyping=""
    fi
    if [[ "$is_prototyping" == "" ]]; then
      # if current_prototypes exists and contains files (recursively), we assume the current install it is a prototyping install
      local current_prototypes="/home/$pyrunner_user/.PyRInstall/Prototypes"
      if [[ -d "$current_prototypes" ]] && [[ -n "$(find "$current_prototypes" -type f -print -quit 2>/dev/null)" ]]; then
        is_prototyping="true"
      else
        # no prototypes, so not prototyping
        is_prototyping="false"
      fi
    fi

    device_ip=$(get_option_from_options "DEVICEIP" "$PYRUNNER_INSTALL_OPTIONS")
    if [[ -z "$device_ip" ]]; then
      device_ip=$(get_ip_address 2>/dev/null) || device_ip=""
      if [[ -z "$device_ip" ]]; then
        device_ip="192.168.0.2"
      fi
    fi

    flash_fw_flags=$(get_option_from_options "FLASH" "$PYRUNNER_INSTALL_OPTIONS")
    if [[ -z $flash_fw_flags ]]; then
      flash_fw_flags="511"  # default value
    fi
    
    force_flash_fw_flags=$(get_option_from_options "FORCEFLASH" "$PYRUNNER_INSTALL_OPTIONS")
    if [[ -z $force_flash_fw_flags ]]; then
      force_flash_fw_flags="0"  # default value
    fi

    allow_pyrunner_overwrite=$(get_option_from_options "OVERWRITE" "$PYRUNNER_INSTALL_OPTIONS")
    if [[ -z $allow_pyrunner_overwrite ]]; then
      allow_pyrunner_overwrite="true"  # default value
    fi
  fi

  echo ""
  echo " validating install..."
  
  local valid_install=false
  if [[ "$INSTALL_APPLICATIONS" == "yes" ]]; then
    if [[ "$FRAMEWORK_LANGUAGE" == "nodejs" ]]; then
      if  [[ -f "./apps/bodhi-api/start.js" ]] && \
          [[ -f "./apps/bodhi-ui/index.html" ]] && \
          [[ -f "./apps/swp-PyReader/VirtualEnv/bin/python" ]]; then
          valid_install=true
      fi
    else
      if  [[ -f "./apps/bodhi-dotnet/auth/MMPR.SimpleIdentityProviderHost" ]] && \
          [[ -f "./apps/bodhi-dotnet/api/MMPR.API" ]] && \
          [[ -f "./apps/bodhi-dotnet/ws/MMPR.WebSocketServer" ]] && \
          [[ -f "./apps/bodhi-dotnet/ui/MMPR.WebUiServer" ]] && \
          [[ -f "./apps/bodhi-dotnet/control/MMPR.ControlService" ]] && \
          [[ -f "./apps/bodhi-ui/index.html" ]] && \
          [[ -f "./apps/swp-PyReader/VirtualEnv/bin/python" ]]; then
        valid_install=true
      fi
    fi
  fi

  if [[ "$valid_install" == "true" ]] && [[ "$INSTALL_PYRUNNER" == "yes" ]]; then
    # check if the pyrunner folder exists and has the inno_unpacked sub-folder
    # only support install from inno_unpacked for now

    local install_pyrunner=false
    if [[ -d "./pyrunner" ]]; then
      # if the pyrunner folder exists, we use it 
      # but only if the inno_unpacked sub-folder exists which it should else is an issue with the install zip
      local inno_unpacked="./pyrunner/inno_unpacked"
      if [[ -d "${inno_unpacked}" ]]; then

        # check that the inno_unpacked folder is not empty
        # the unpacked folder should also contain the following file 
        # indicating we created the inno_unpacked folder: install_script.iss, pyrunner-install-file-name

        if [[ -z "$(ls -A "${inno_unpacked}" 2>/dev/null)" ]] ||
            [[ ! -f "${inno_unpacked}/pyrunner-install-file-name" ]]; then
          valid_install=false
        else

          # Validate user exists
          if ! id "$pyrunner_user" &>/dev/null; then
              echo "   ERROR: user '$pyrunner_user' does not exist, cannot install pyrunner!"
              valid_install=false
          fi

          # validate user is member of pyrunner_user_group
          if ! groups "$pyrunner_user" | grep -q "\b$pyrunner_user_group\b"; then
              echo "   ERROR: user '$pyrunner_user' is not a member of group '$pyrunner_user_group', cannot install pyrunner!"
              valid_install=false
          fi  

          # we have to do some maintanence on the pyrunner files
          if [[ ! -f "$inno_unpacked/{app}/Setup/PyPack/FWUpdate.sh" ]]; then
            # this is a required file
            # the unpacking did try to write 2 files with the same name: FWUpdate,1.sh and FWUpdate,2.sh
            # one was for simulation and one for real device
            if [[ "$is_simulation" == "true" ]]; then
              # we keep the FWUpdate,2.sh file
              if [[ -f "$inno_unpacked/{app}/Setup/PyPack/FWUpdate,2.sh" ]]; then
                mv -f "$inno_unpacked/{app}/Setup/PyPack/FWUpdate,2.sh" "$inno_unpacked/{app}/Setup/PyPack/FWUpdate.sh"
              fi
            else
              # we keep the FWUpdate,1.sh file
              if [[ -f "$inno_unpacked/{app}/Setup/PyPack/FWUpdate,1.sh" ]]; then
                mv -f "$inno_unpacked/{app}/Setup/PyPack/FWUpdate,1.sh" "$inno_unpacked/{app}/Setup/PyPack/FWUpdate.sh"
              fi
            fi
          fi
          rm -f "$inno_unpacked/{app}/Setup/PyPack/FWUpdate,1.sh"
          rm -f "$inno_unpacked/{app}/Setup/PyPack/FWUpdate,2.sh"

          local source_install_config_file="${inno_unpacked}/install_script.iss"
          local current_pyrunner_pack_config_HAL="/home/$pyrunner_user/pyrunner/lib/${python_version}/site-packages/PyRunner/config/HAL.cfg"

          # Validate PyRunner structure
          validate_pyrunner \
            source_install_config_file="$source_install_config_file" \
            source_firmware="${inno_unpacked}/{app}/Setup/Firmware" \
            source_protocols="${inno_unpacked}/{app}/Setup/PresetProtocols" \
            source_pypack="${inno_unpacked}/{app}/Setup/PyPack" \
            source_raspbian="${inno_unpacked}/{app}/Setup/PyPack/Raspbian" \
            source_config="${inno_unpacked}/{commonappdata}/Revvity" 
          local exit_code=$?
          if [[ $exit_code -ne 0 ]]; then
            echo " ERROR: PyRunner validation failed!"
            valid_install=false
          else
            install_pyrunner=true

            # Check current version
            echo "  checking currently installed PyRunner version..."
            local next_version=$(get_ini_value "AppVersion" "Setup" "$source_install_config_file" 2>/dev/null || echo "")
            local current_version=$(get_ini_value "Version" "Application" "$current_pyrunner_pack_config_HAL" 2>/dev/null || echo "")
            if [[ -n "$current_version" ]]; then
              if [[ "$current_version" = "$next_version" ]]; then
                echo "   PyRunner version $current_version is already installed!"
                if [[ "$allow_pyrunner_overwrite" = "true" ]]; then
                  echo "   forcing installation due to allow_pyrunner_overwrite=$allow_pyrunner_overwrite..."
                else
                  echo "   don't install pyrunner - same version already present and allow_pyrunner_overwrite=$allow_pyrunner_overwrite."
                  install_pyrunner=false
                fi
              else
                echo "   upgrading from version $current_version to $next_version"
              fi
            else
              echo "   PyRunner does not seem to be installed or current version could not be read!"
            fi
          fi
        fi
      else
        echo " ERROR: PyRunner inno_unpacked folder not found!"
        valid_install=false
      fi
    else
      echo ""
      echo " WARNING: PyRunner folder not found in this install ! [this must be an install without PyRunner... and that's supported]"
      echo "    PyRunner will not be updated, please update it manually from the controlling laptop if needed"
    fi
  fi

  if [[ "${valid_install}" != "true" ]]; then
      echo " ERROR: the zip file DOES NOT seem to be a valid install!"
      exit 1 # yes, we exit the script here
  fi

  mkdir -p "${bodhi_folder_run}/next" "${bodhi_folder_run}/current" "${bodhi_folder_run}/previous"

  if [[ "$INSTALL_APPLICATIONS" == "yes" ]]; then
    if [[ -d "${bodhi_folder_run}/next/apps" ]]; then
      rm -r -f "${bodhi_folder_run}/next/apps"
    fi
    mkdir -p "${bodhi_folder_run}/next/apps"

    if [[ -d "${bodhi_folder_run}/next/control" ]]; then
      rm -r -f "${bodhi_folder_run}/next/control"
    fi
    mkdir -p "${bodhi_folder_run}/next/control"
  fi
  
  if [[ -d "${bodhi_folder_run}/next/pyrunner" ]]; then
    rm -r -f "${bodhi_folder_run}/next/pyrunner"
  fi

  if [[ "${install_pyrunner}" == "true" ]]; then
    mkdir -p "${bodhi_folder_run}/next/pyrunner"
    mv -f "./pyrunner" "${bodhi_folder_run}/next"
  fi

  if [[ "$INSTALL_APPLICATIONS" == "yes" ]]; then
    if [[ "$FRAMEWORK_LANGUAGE" == "nodejs" ]]; then
      local apps=(
        "bodhi-api"
        "bodhi-ui"
        "swp-PyReader"
      )
    fi
    if [[ "$FRAMEWORK_LANGUAGE" == "dotnet" ]]; then

      # we keep the 'ControlService' outside of the apps folder  
      # so that it can be managed separately
      if [[ -d "./apps/bodhi-dotnet/control" ]]; then
        mkdir -p "${bodhi_folder_run}/next/control/bodhi-dotnet"
        mv -f "./apps/bodhi-dotnet/control" "${bodhi_folder_run}/next/control/bodhi-dotnet"
      fi

      local apps=(
        "bodhi-ui"
        "bodhi-dotnet"
        "swp-PyReader"
      )
    fi
    for app in "${apps[@]}"; do
      local sourceDir="./apps/$app"
      if [[ -d "$sourceDir" ]]; then
        mv -f "$sourceDir" "${bodhi_folder_run}/next/apps"
      fi
    done

    # make sure the MMPR files are excutable
    find "${bodhi_folder_run}/next/control/bodhi-dotnet" -type f -name 'MMPR*' -exec chmod +x {} \;
    find "${bodhi_folder_run}/next/apps/bodhi-dotnet" -type f -name 'MMPR*' -exec chmod +x {} \;
  fi

  # get version from build file
  local VERSION=""
  local version_file_path="./apps/${version_file_name}"
  if [[ -f "${version_file_path}" ]]; then
    VERSION=$( cat ${version_file_path} )
  else
    # at least write something...for older installs that do not write the version
    VERSION=${INSTALL_APPLICATIONS_FILENAME}
  fi

  rm -r -f "./apps"

  echo ""
  update_next_host_public_name

  if [[ "$INSTALL_APPLICATIONS" == "yes" ]]; then
    if [[ -d "${bodhi_folder_run}/next/scripts" ]]; then
      rm -r -f "${bodhi_folder_run}/next/scripts"
    fi
    if [[ -d "${bodhi_folder_installs}/next/scripts" ]]; then
      cp -a "${bodhi_folder_installs}/next/scripts" "${bodhi_folder_run}/next/scripts"
    fi
  fi

  echo ""
  echo " stopping services..."
  stop_services
  
  # wait for services to stop
  sleep 10

  echo ""

  local what_we_deploy=""
  if [[ "$INSTALL_APPLICATIONS" == "yes" ]]; then
    what_we_deploy="bodhi applications"
  fi
  if [[ "$INSTALL_PYRUNNER" == "yes" ]]; then
    if [[ "${install_pyrunner}" == "true" ]]; then
      if [[ -z "$what_we_deploy" ]]; then
        what_we_deploy="PyRunner"
      else
        what_we_deploy="${what_we_deploy} and PyRunner"
      fi
    fi
  fi
  echo " deploying ${what_we_deploy}..."
  echo ""

  if [[ "$INSTALL_PYRUNNER" == "yes" ]] && [[ "${install_pyrunner}" == "true" ]]; then
    local reports_dir="${run_scripts_log_directory}/pyrunner"
    if ! create_pyrunner_report \
        stage="initial" \
        reports_dir="$reports_dir" \
        home_dir="/home/$pyrunner_user"; then
      echo " ERROR: PyRunner 'initial' report creation failed!"
    fi

    # Backup existing PyRunner installation before deploying new one
    if [[ "${install_pyrunner}" == "true" ]]; then
      if ! backup_pyrunner \
          current_path="/home/$pyrunner_user" \
          backup_path="$bodhi_folder_run/previous/pyrunner"; then
        echo " ERROR: PyRunner backup failed!"
        return 1
      fi
    fi
  fi

  if [[ "$INSTALL_APPLICATIONS" == "yes" ]]; then
    # backup existing apps
    if [[ -d "${bodhi_folder_run}/next/apps" ]]; then
      echo "  backing up existing application..."
      if [[ -d "${bodhi_folder_run}/previous/apps" ]]; then
        rm -r -f "${bodhi_folder_run}/previous/apps"
      fi
      if [[ -d "${bodhi_folder_run}/current/apps" ]]; then
        mv -f "${bodhi_folder_run}/current/apps" "${bodhi_folder_run}/previous/apps"
      fi
    fi

    # backup existing control
    if [[ -d "${bodhi_folder_run}/next/control" ]]; then
      echo "  backing up existing control..."
      if [[ -d "${bodhi_folder_run}/previous/control" ]]; then
        rm -r -f "${bodhi_folder_run}/previous/control"
      fi
      if [[ -d "${bodhi_folder_run}/current/control" ]]; then
        mv -f "${bodhi_folder_run}/current/control" "${bodhi_folder_run}/previous/control"
      fi
    fi

    # backup existing scripts
    if [[ -d "${bodhi_folder_run}/next/scripts" ]]; then
      echo "  backing up existing scripts..."
      if [[ -d "${bodhi_folder_run}/previous/scripts" ]]; then
        rm -r -f "${bodhi_folder_run}/previous/scripts"
      fi
      if [[ -d "${bodhi_folder_run}/current/scripts" ]]; then
        mv -f "${bodhi_folder_run}/current/scripts" "${bodhi_folder_run}/previous/scripts"
      fi
    fi

    # backup info
    if [[ -f "${bodhi_folder_run}/current/${version_file_name}" ]]; then
      mv -f "${bodhi_folder_run}/current/${version_file_name}" "${bodhi_folder_run}/previous/${version_file_name}"
    fi
    if [[ -f "${bodhi_folder_run}/current/${install_file_name}" ]]; then
      mv -f "${bodhi_folder_run}/current/${install_file_name}" "${bodhi_folder_run}/previous/${install_file_name}"
    fi
    if [[ -f "${bodhi_folder_run}/current/${host_public_name_file_name}" ]]; then
      mv -f "${bodhi_folder_run}/current/${host_public_name_file_name}" "${bodhi_folder_run}/previous/${host_public_name_file_name}"
    fi
    if [[ -f "${bodhi_folder_run}/current/${installation_datetime_file_name}" ]]; then
      mv -f "${bodhi_folder_run}/current/${installation_datetime_file_name}" "${bodhi_folder_run}/previous/${installation_datetime_file_name}"
    fi
  fi

  if [[ "$SET_LOCALIZATION" == "yes" ]]; then
    set_localization
  fi

  if [[ "$INSTALL_PYRUNNER" == "yes" ]]; then
    # Perform PyRunner installation
    if [[ "${install_pyrunner}" == "true" ]]; then
      echo ""
      echo "  using python version=${python_version} [as hardcoded in the inno install script]"
      echo "  pyrunner user=${pyrunner_user}, group=${pyrunner_user_group} [as hardcoded in the inno install script]"
      echo "  PyRunner options: [ passed as '${PYRUNNER_INSTALL_OPTIONS}' ]"
      echo "   using inventory:              '$inventory'"
      echo "   is demo/simulation:           $is_simulation"
      echo "   is develop:                   $is_develop"
      echo "   is prototyping:               $is_prototyping"
      echo "   device IP:                    $device_ip"
      echo "   firmware flash flags:         $flash_fw_flags"
      echo "   firmware force flash flags:   $force_flash_fw_flags"

      # current installation file was moved to the backup folder
      local prev_pyrunner_pack_config_HAL="${bodhi_folder_run}/previous/pyrunner/lib/${python_version}/site-packages/PyRunner/config/HAL.cfg"
      local prev_pyrunner_pack_config_MeasurementUnit="${bodhi_folder_run}/previous/pyrunner/lib/${python_version}/site-packages/PyRunner/config/MeasurementUnit.cfg"

      if perform_pyrunner_installation \
          device_ip="$device_ip" \
          python_version="$python_version" \
          target_user="$pyrunner_user" \
          target_user_group="$pyrunner_user_group" \
          inventory="$inventory" \
          is_simulation="$is_simulation" \
          is_develop="$is_develop" \
          is_prototyping="$is_prototyping" \
          flash_fw_flags="$flash_fw_flags" \
          force_flash_fw_flags="$force_flash_fw_flags" \
          current_pyrunner_pack_config_HAL="$prev_pyrunner_pack_config_HAL" \
          current_pyrunner_pack_config_MeasurementUnit="$prev_pyrunner_pack_config_MeasurementUnit" \
          source_install_config_file="${bodhi_folder_run}/next/pyrunner/inno_unpacked/install_script.iss" \
          source_firmware="${bodhi_folder_run}/next/pyrunner/inno_unpacked/{app}/Setup/Firmware" \
          source_protocols="${bodhi_folder_run}/next/pyrunner/inno_unpacked/{app}/Setup/PresetProtocols" \
          source_pypack="${bodhi_folder_run}/next/pyrunner/inno_unpacked/{app}/Setup/PyPack" \
          source_raspbian="${bodhi_folder_run}/next/pyrunner/inno_unpacked/{app}/Setup/PyPack/Raspbian" \
          source_prototypes="${bodhi_folder_run}/next/pyrunner/inno_unpacked/{app}/Setup/Prototypes" \
          source_config="${bodhi_folder_run}/next/pyrunner/inno_unpacked/{commonappdata}/Revvity" \
          pyrunner_systemd="$pyrunner_systemd" \
          django_systemd="$django_systemd" \
          chownwdog_systemd="$chownwdog_systemd"; then

          # cleanup the next pyrunner folder, remove all empty directories recursively
          # this will help us identify what files were not moved to /home/$pyrunner_user
          find "${bodhi_folder_run}/next/pyrunner" -type d -empty -print0 2>/dev/null | while IFS= read -r -d '' dir; do
            if rmdir "$dir" 2>/dev/null; then
              # Successfully removed directory, now check if parent is empty and remove it too
              parent="$(dirname "$dir")"
              while [[ "$parent" != "${bodhi_folder_run}/next/pyrunner" ]] && [[ "$parent" != "/" ]] && [[ "$parent" != "." ]]; do
                # Check if parent directory is empty before trying to remove it
                if [[ -d "$parent" ]] && [[ -z "$(ls -A "$parent" 2>/dev/null)" ]]; then
                  if rmdir "$parent" 2>/dev/null; then
                    parent="$(dirname "$parent")"
                  else
                    break
                  fi
                else
                  break
                fi
              done
            fi
          done

          # make sure the logs folder exists
          mkdir -p "/home/$pyrunner_user/logs"
          # restore the logs folder from backup: we want pyrunner log continuation
          if [[ -d "${bodhi_folder_run}/previous/pyrunner/logs" ]]; then
            cp -a "${bodhi_folder_run}/previous/pyrunner/logs"/* "/home/$pyrunner_user/logs/" 2>/dev/null || true
          fi
          # make sure ownership is correct
          chown -R "$pyrunner_user:$pyrunner_user_group" "/home/$pyrunner_user/logs"

          # make sure the .config folder exists
          mkdir -p "/home/$pyrunner_user/.config"
          # restore .config from backup
          # apparently these files are created outside installs with Kaleido/GroudControl 
          if [[ -d "${bodhi_folder_run}/previous/pyrunner/.config" ]]; then
            
            # Check for existing files and warn before copying
            local source_config_dir="${bodhi_folder_run}/previous/pyrunner/.config"
            local dest_config_dir="/home/$pyrunner_user/.config"
            local files_copied=0
            local files_overwritten=0
            
            # Iterate through all files in source directory
            while IFS= read -r -d '' source_file; do
              local relative_path="${source_file#${source_config_dir}/}"
              local dest_file="${dest_config_dir}/${relative_path}"
              
              if [[ -e "$dest_file" ]]; then
                echo "   WARNING: overwriting existing file: $dest_file"
                ((files_overwritten++))
              fi
              
              # Create destination directory if needed
              local dest_dir="$(dirname "$dest_file")"
              mkdir -p "$dest_dir"
              
              # Copy the file
              if cp -a "$source_file" "$dest_file" 2>/dev/null; then
                ((files_copied++))
              else
                echo "   ERROR: failed to copy $source_file to $dest_file"
              fi
            done < <(find "$source_config_dir" -type f -print0 2>/dev/null)
            
            if [[ $files_copied -gt 0 ]]; then
              echo "   .config restore: copied $files_copied files ($files_overwritten overwrites)"
            fi
          fi
          # make sure ownership is correct
          chown -R "$pyrunner_user:$pyrunner_user_group" "/home/$pyrunner_user/.config"

          # Run FI Bottom script if enabled
          if [[ "$(is_in_inventory "$inventory" "FIBottom")" = "true" ]]; then
              run_fi_bottom_adjustment_script "${bodhi_folder_installs}/next/scripts" "$pyrunner_user"
          fi

          # list what is left in the next pyrunner folder to "$reports_dir/leftovers.txt
          local leftovers_file="${reports_dir}/leftovers.txt"
          mkdir -p "$(dirname "$leftovers_file")"
          rm -f "$leftovers_file"
          find "${bodhi_folder_run}/next/pyrunner" -type f -print0 | while IFS= read -r -d '' file; do
            echo "$file" >> "$leftovers_file"
          done
          echo "  PyRunner install leftover files list written to: $leftovers_file"

          local reports_dir="${run_scripts_log_directory}/pyrunner"
          if ! create_pyrunner_report \
              stage="final" \
              reports_dir="$reports_dir" \
              home_dir="/home/$pyrunner_user"; then
            echo " ERROR: PyRunner 'final' report creation failed!"
          fi

        echo "  PyRunner installation completed successfully!"
      else 
        echo " ERROR: PyRunner installation failed!"
      fi
    fi
  fi

  if [[ "$INSTALL_APPLICATIONS" == "yes" ]]; then
    # update the run folder with the next apps, control and scripts
    echo ""
    if [[ -d "${bodhi_folder_run}/next/apps" ]]; then
      echo "  installing new applications..."
      mv -f "${bodhi_folder_run}/next/apps" "${bodhi_folder_run}/current/apps"
    fi
    if [[ -d "${bodhi_folder_run}/next/control" ]]; then
      echo "  installing new control..."
      mv -f "${bodhi_folder_run}/next/control" "${bodhi_folder_run}/current/control"
    fi
    if [[ -d "${bodhi_folder_run}/next/scripts" ]]; then
      echo "  installing new scripts..."
      mv -f "${bodhi_folder_run}/next/scripts" "${bodhi_folder_run}/current/scripts"
    fi
    echo ""

    if [[ "$CREATE_SERVICES" == "yes" ]] || [[ "$CREATE_SERVICES" == "overwrite" ]]; then
      create_services
    fi

    if [[ "$EXECUTE_DATABASE_OPS" != "nop" ]]; then
      execute_database_ops
    fi
  fi

  # keep track what was installed and is running next for easy query later
  echo " writing install info..."
  
  echo "   ${version_file_name}: ${VERSION}" 
  echo -n ${VERSION} > "${bodhi_folder_run}/current/${version_file_name}"

  echo "   ${install_file_name}: ${INSTALL_APPLICATIONS_FILENAME}" 
  echo -n ${INSTALL_APPLICATIONS_FILENAME} > "${bodhi_folder_run}/current/${install_file_name}"

  echo "   ${host_public_name_file_name}: ${HOST_PUBLIC_NAME}" 
  echo -n ${HOST_PUBLIC_NAME} > "${bodhi_folder_run}/current/${host_public_name_file_name}"

  echo "   ${installation_datetime_file_name}: ${run_datetime}" 
  echo -n ${run_datetime} > "${bodhi_folder_run}/current/${installation_datetime_file_name}"

  if [[ "$INSTALL_APPLICATIONS" == "yes" ]]; then 
    if [[ -d "${bodhi_folder_installs}/next/apps" ]]; then
      if [[ -d "${bodhi_folder_installs}/previous/apps" ]]; then
        rm -r -f "${bodhi_folder_installs}/previous/apps"
      fi
      if [[ -d "${bodhi_folder_installs}/current/apps" ]]; then
        mv -f "${bodhi_folder_installs}/current/apps" "${bodhi_folder_installs}/previous/apps"
      fi
      mv -f "${bodhi_folder_installs}/next/apps" "${bodhi_folder_installs}/current/apps"
    fi

    if [[ -d "${bodhi_folder_installs}/next/scripts" ]]; then
      if [[ -d "${bodhi_folder_installs}/previous/scripts" ]]; then
        rm -r -f "${bodhi_folder_installs}/previous/scripts"
      fi
      if [[ -d "${bodhi_folder_installs}/current/scripts" ]]; then
        mv -f "${bodhi_folder_installs}/current/scripts" "${bodhi_folder_installs}/previous/scripts"
      fi
      mv -f "${bodhi_folder_installs}/next/scripts" "${bodhi_folder_installs}/current/scripts"
    fi
  fi


  # remove 'next' just in case it has leftovers
  if [[ -d "${bodhi_folder_run}/next" ]]; then
    rm -r -f "${bodhi_folder_run}/next"
  fi
  if [[ -d "${bodhi_folder_installs}/next" ]]; then
    rm -r -f "${bodhi_folder_installs}/next"
  fi


  # we no longer need 'previous'
  # remove all directories recursive, but keep the previous install info files
  if [[ -d "${bodhi_folder_run}/previous" ]]; then
    find "${bodhi_folder_run}/previous" -mindepth 1 -not -name "${version_file_name}" -not -name "${install_file_name}" -not -name "${host_public_name_file_name}" -not -name "${installation_datetime_file_name}" -exec rm -r -f {} + >/dev/null 2>&1
  fi

  # remove the tmp location where we keep the unzipped software updates
  if [[ -d "${tmp_bodhi_folder_software_updates}" ]]; then
    rm -r -f "${tmp_bodhi_folder_software_updates}"
  fi

  echo ""
  echo " starting services..."
  start_services

  if [[ -d "${initial_dir}" ]]; then
    cd $initial_dir
  fi

  echo ""
  echo "done - installation completed at $(date)"
  echo ""
}

# Run FI Bottom script if FIBottom is in inventory
# Parameters:
#   bodhi_scripts_dir - the bodhi-apps-scripts scripts directory
#   target_user - the user to run the script as
run_fi_bottom_adjustment_script() {
    local bodhi_scripts_dir="$1"
    local target_user="$2"

    # determine home directory of target user
    local home_dir="/home/${target_user}"

    # this is the hardcoded script name
    local script_name="merge_fi_bottom_to_gc.sh"

    # determine script locations
    local pyrunner_script="$home_dir/$script_name"
    local bodhi_script="${bodhi_scripts_dir}/lib/$script_name"

    # echo "    checking if we have FI Bottom script from PyRunner scripts suite: $pyrunner_script"
    if [[ -f "$pyrunner_script" ]]; then
        echo "    running FI Bottom script from PyRunner scripts suite: $pyrunner_script"
        if ! sudo -u "$target_user" bash "$pyrunner_script" "$target_user"; then
            local exit_code=$?
            echo "    WARNING: FI Bottom script from PyRunner scripts suite failed with exit code: $exit_code"
        fi
    else
        # echo "    FI Bottom script not found in PyRunner scripts suite, checking bodhi-apps-scripts suite: $bodhi_script"
        if [[ -f "$bodhi_script" ]]; then
            echo "    running FI Bottom script from bodhi-apps-scripts suite: $bodhi_script"
            if ! sudo -u "$target_user" bash "$bodhi_script" "$target_user"; then
                local exit_code=$?
                echo "    WARNING: FI Bottom script from bodhi-apps-scripts failed with exit code: $exit_code"
            fi
        else
            echo "    WARNING: FI Bottom script not found in either PyRunner or bodhi-apps-scripts suite"
        fi
    fi
}
