
create_service_report_tmp_folder() {
    mkdir -p "${tmp_bodhi_folder_reports}"
    randomDir=$(mktemp -d "${tmp_bodhi_folder_reports}/report.XXXXXX")
    mkdir -p "${randomDir}"
    echo "${randomDir}"
}

generate_service_report_name() {
    local current_datetime=$1
    local hostname=$(hostname -f)
    local service_report_name="report_${hostname}_${current_datetime}"
    echo "${service_report_name}"
}

generate_service_report() {
    local current_datetime=$(date +"%Y-%m-%d_%H-%M-%S")

    local service_report_tmp_folder=$(create_service_report_tmp_folder)
    local service_report_name=$(generate_service_report_name $current_datetime)

    local service_report_tmp_file_path="${service_report_tmp_folder}/${current_datetime}.log"
    local service_report_zip_file_name="${service_report_name}.zip"

    echo "service_report_tmp_folder=$service_report_tmp_folder"
    echo "service_report_tmp_file_path=$service_report_tmp_folder"

    echo "Open log at $(date)" > "${service_report_tmp_file_path}"
    echo "" >> "${service_report_tmp_file_path}"
    echo "" >> "${service_report_tmp_file_path}"

    generate_services_health_report "${service_report_tmp_folder}" "${service_report_tmp_file_path}"
    generate_service_report_system_info "${service_report_tmp_folder}" "${service_report_tmp_file_path}"
    generate_services_report "${service_report_tmp_folder}" "${service_report_tmp_file_path}"
    generate_databases_info "${service_report_tmp_folder}" "${service_report_tmp_file_path}"
    generate_bodhi_applications_report "${service_report_tmp_folder}" "${service_report_tmp_file_path}"
    generate_pyrunner_report "${service_report_tmp_folder}" "${service_report_tmp_file_path}"
    generate_service_report_nginx "${service_report_tmp_folder}" "${service_report_tmp_file_path}"

    echo "" >> "${service_report_tmp_file_path}"
    echo "" >> "${service_report_tmp_file_path}"
    echo "Close log at $(date)" >> "${service_report_tmp_file_path}"

    mkdir -p "${bodhi_folder_reports}"
    local service_report_zip_file_path="${bodhi_folder_reports}/${service_report_name}.zip"

    initial_dir=$(pwd)
    cd "${service_report_tmp_folder}"
    zip -r "${service_report_zip_file_path}" .
    cd $initial_dir
    
    if [[ -d "${service_report_tmp_folder}" ]]; then
        rm -rf "${service_report_tmp_folder}"
    fi

    echo "GENERATE_SERVICE_REPORT_EXIT_ERROR NoError"
    echo "GENERATE_SERVICE_REPORT_EXIT_STATUS true"
    echo "SERVICE_REPORT_NAME ${service_report_name}"
    echo "SERVICE_REPORT_ZIP_FILE_NAME ${service_report_zip_file_name}"
    echo "SERVICE_REPORT_ZIP_FILE_PATH ${service_report_zip_file_path}"
}

