# basic_calculator.py
import ast
from calculation_methods.py_calculations.calculation_factory import CalculationFactory
from calculation_methods.py_calculations.error_handler.error_messages import ErrorMessages
from calculation_methods.py_calculations import calculation_utils as utils

class BasicCalculations:
    # Calculator for basic arithmetic
    def __init__(self, x, y, operator):
        # Initialize with operands and operator
        self.x = self.parse_input(x)
        self.y = self.parse_input(y)
        self.strategy = CalculationFactory.create_basic_calculation(operator)
    
    def parse_input(self, value):
        # Parse string input to number
        if isinstance(value, str):
            try:
                return ast.literal_eval(value)
            except (ValueError, SyntaxError):
                utils.handle_error(ErrorMessages.ERROR_INVALID_DATA)
        return value
    
    def basic_calculations(self):
        # Perform calculation based on input types
        try:
            if isinstance(self.x, (int, float)) and isinstance(self.y, (int, float)):
                result = self.strategy.calculate(self.x, self.y)
            elif isinstance(self.x, list) and isinstance(self.y, (int, float)):
                result = [self.strategy.calculate(x, self.y) for x in self.x]
            elif isinstance(self.x, (int, float)) and isinstance(self.y, list):
                result = [self.strategy.calculate(self.x, y) for y in self.y]
            elif isinstance(self.x, list) and isinstance(self.y, list):
                if len(self.x) != len(self.y):
                    utils.handle_error(ErrorMessages.ERROR_LIST_LENGTH_DIFFERENT)
                result = [self.strategy.calculate(self.x[i], self.y[i]) 
                         for i in range(len(self.x))]
            else:
                utils.handle_error(ErrorMessages.ERROR_INVALID_DATA)
            return self.strategy.format_result(result)
        except Exception:
            utils.handle_error(ErrorMessages.ERROR_INTERNAL_SERVER)