from django.http import JsonResponse
import numpy as np
import logging
from calculation_methods.py_calculations.calculation_utils import handle_error
from calculation_methods.py_calculations.error_handler.error_messages import ErrorMessages
log = logging.getLogger('django')

class BlankCorrections:
    def __init__(self, blank_values=None, input_data=None):
        self.blank_values = blank_values
        self.input_data = input_data

    def blank_correction(self):
        try:
            # Ensure all blank values are floats
            float_blank_values = np.array(list(self.blank_values), dtype=float)
            if len(float_blank_values) == 0:
                handle_error(ErrorMessages.ERROR_BLANK_VALUES_EMPTY)

            b_average = np.mean(float_blank_values)
            # Convert input data to numpy array for vectorized operations
            input_array = np.array(list(self.input_data), dtype=float)
            corrected_array = input_array - b_average
            # Convert the corrected array back to the original dictionary format
            corrected_data = corrected_array.tolist()
            return corrected_data

        except Exception as e:
            error_message = {"error": str(e)}
            formatted_message = ErrorMessages.ERROR_BLANK_CORRECTION_FAILED["message"].format(str(e))
            handle_error({"code": ErrorMessages.ERROR_BLANK_CORRECTION_FAILED["code"], "message": formatted_message})
            return JsonResponse(error_message, status =400)