from abc import ABC, abstractmethod
import numpy as np

class CalculationStrategy(ABC):
    # Abstract base class for calculation strategies
    @abstractmethod
    def calculate(self, *args):
        # Define calculation method to be implemented by subclasses
        pass
    @staticmethod
    def format_result(result):
        # Format result to avoid scientific notation
        if isinstance(result, (int, float)) and not np.isnan(result):
            return np.format_float_positional(result, trim='-') if result != 0 else 0
        elif isinstance(result, list):
            return [CalculationStrategy.format_result(r) for r in result]
        return result