
class ErrorMessages:
    # Basic Calculation error messages
    ERROR_INVALID_OPERATOR = {
        "code": "invalidOperator",
        "message": "Invalid operator: {0}. Must be one of {1}."
    }

    # Blank Correction error messages
    ERROR_BLANK_VALUES_EMPTY = {
        "code": "blankValuesEmpty",
        "message": "Blank values list is empty. Cannot perform blank correction."
    }
    ERROR_BLANK_CORRECTION_FAILED = {
        "code": "blankCorrectionFailed",
        "message": "An error occurred while calculating blank correction: {0}"
    }
    # Cubic Spline error messages
    ERROR_PROCESS_VALUES = {
        "code": "processValues",
        "message": "Error in process and get all values: {0}"
    }
    ERROR_PREDICT_X = {
        "code": "predictX",
        "message": "Error in predict x: {0}"
    }
    ERROR_GENERATE_TABLE = {
        "code": "generateTable",
        "message": "Error in generate additional table by sample groups: {0}"
    }
    ERROR_GET_COEFFICIENTS = {
        "code": "getCoefficients",
        "message": "Error in get coefficients: {0}"
    }
    ERROR_GET_METRICS = {
        "code": "getMetrics",
        "message": "Error getting metrics: {0}"
    }

    # 4PL and 5PL error messages
    ERROR_CONVERTING_FLOAT = {
        "code": "convertingFloat",
        "message": "Error converting points to float: {0}"
    }
    ERROR_MODEL_CALCULATION = {
        "code": "modelCalculationError",
        "message": "Error in {model_type}: {error}"
    }
    ERROR_CALCULATE_PARAMS = {
        "code": "calculateParams",
        "message": "Error calculating params: {0}"
    }
    ERROR_CALCULATE_LLD = {
        "code": "calculateLLD",
        "message": "Error calculating LLD: {0}"
    }
    ERROR_CALCULATE_METRICS = {
        "code": "calculateMetrics",
        "message": "Error in calculating metrics: {0}"
    }

    

    # py calculations
    ERROR_INVALID_REQUEST = {
        "code": "invalidRequest",
        "message": "Invalid request method"
    }
    ERROR_METHOD_NOT_ALLOWED = {
        "code": "methodNotAllowed",
        "message": "Method not allowed"
    }

    # Sampletype Statistics error messages
    ERROR_STATISTICAL_CALCULATION = {
        "code": "calculationError",
        "message": "An error occurred while calculating {operation}: {error}"
    }

    # Validations error messages
    ERROR_LIST_LENGTH_DIFFERENT = {
        "code": "listLengthDifferent",
        "message": "Lists must be of the same length."
    }
    ERROR_DIVISION_BY_ZERO = {
        "code": "divisionByZero",
        "message": "Division by Zero"
    }
    ERROR_INVALID_DATA = {
        "code": "invalidData",
        "message": "Invalid Input data. Check for NaN or Inf values."
    }
    ERROR_INSUFFICIENT_DATA_POINTS = {
        "code": "insufficientDataPoints",
        "message": "Insufficient Data Points"
    }
    ERROR_CALCULATE_CURVE_Y = {
        "code": "calculateCurveY",
        "message": "Error calculating curve_y : {0}"
    }
    ERROR_NO_STANDARDS_DATA = {
        "code": "noStandardsData",
        "message": "standard_values are missing"
    }
    ERROR_INCORRECT_MODEL = {
        "code": "incorrectModel",
        "message": "Unsupported model type: {0}"
    }
    ERROR_GENERATE_CURVE_POINTS = {
        "code": "generateCurvePoints",
        "message": "Error while generating curve data points: {0}"
    }

    # Consolidated Internal Server Error
    ERROR_INTERNAL_SERVER = {
        "code": "internalServerError",
        "message": "Internal server error"
    }

    # Consolidated Missing Input Data Error
    ERROR_MISSING_INPUT_DATA = {
        "code": "missingInputData",
        "message": "Input data is missing or empty."
    }