from django.http import JsonResponse
from calculation_methods.py_calculations.error_handler.error_messages import ErrorMessages

class ResponseHandler:
    @staticmethod
    def success_response(identifier, result):
        return {
            "id": identifier,
            "result": result
        }

    @staticmethod
    def error_response(identifier, error_obj, jsonrpc_code, message=None):
        # If message is not provided, use the message from error_obj
        error_message = message if message else error_obj["message"]
        return {
            "id": identifier,
            "error": {
                "code": f"pyReader_{error_obj['code']}",  #ErrorMessages with pyReder_ prefix
                "rpccode": jsonrpc_code,  # Original JSON-RPC code
                "message": error_message
            }
        }

    @staticmethod
    def method_not_allowed():
        return JsonResponse(
            ResponseHandler.error_response(
                None,
                ErrorMessages.ERROR_METHOD_NOT_ALLOWED,
                -32601
            ),
            status=404
        )

    @staticmethod
    def parse_error(request_id, error_obj):
        return JsonResponse(
            ResponseHandler.error_response(
                request_id,
                error_obj,
                -32700
            ),
            status=400
        )

    @staticmethod
    def invalid_request(request_id, error_obj):
        return JsonResponse(
            ResponseHandler.error_response(
                request_id,
                error_obj,
                -32600
            ),
            status=400
        )

    @staticmethod
    def invalid_params(request_id, error_obj):
        return JsonResponse(
            ResponseHandler.error_response(
                request_id,
                error_obj,
                -32602
            ),
            status=400
        )

    @staticmethod
    def internal_error(request_id, error_obj, message=None):
        return JsonResponse(
            ResponseHandler.error_response(
                request_id,
                error_obj,
                -32603,
                message
            ),
            status=500
        )