from django.http import JsonResponse
from calculation_methods.py_calculations.response_handling.response_handler import ResponseHandler
from calculation_methods.py_calculations.error_handler.error_messages import ErrorMessages
from calculation_methods.py_calculations.calculation_utils import handle_error
import logging

log = logging.getLogger('log_info')

class ResponseUtils:
    @staticmethod
    def handle_value_error(request_id, exception, fallback_error_obj):
        error_code, error_message = exception.args
        # Ensure error_code is a string
        if not isinstance(error_code, str):
            error_code = str(error_code)
        # Find the matching ErrorMessages object, ensuring obj is a dict
        error_obj = None
        for name, obj in vars(ErrorMessages).items():
            if isinstance(obj, dict) and obj.get("code") == error_code:
                error_obj = obj
                break
        if error_obj is None:
            error_obj = fallback_error_obj
        return JsonResponse(
            ResponseHandler.error_response(
                request_id,
                error_obj,
                -32600,
                error_message
            ),
            status=400
        )

    @staticmethod
    def handle_json_decode_error(request_id, exception):
        return handle_error(
            ErrorMessages.ERROR_INTERNAL_SERVER,
            response=ResponseHandler.parse_error(request_id if request_id else '', ErrorMessages.ERROR_INTERNAL_SERVER)
        )

    @staticmethod
    def handle_general_error(request_id, exception, fallback_error_obj):
        error_obj = fallback_error_obj
        if isinstance(exception, TypeError):
            error_obj = ErrorMessages.ERROR_INVALID_DATA
            error_message = ErrorMessages.ERROR_INVALID_DATA["message"]
        elif isinstance(exception, IndexError):
            error_obj = ErrorMessages.ERROR_LIST_LENGTH_DIFFERENT
            error_message = ErrorMessages.ERROR_LIST_LENGTH_DIFFERENT["message"]
        elif isinstance(exception, ZeroDivisionError):
            error_obj = ErrorMessages.ERROR_DIVISION_BY_ZERO
            error_message = ErrorMessages.ERROR_DIVISION_BY_ZERO["message"]
        else:
            error_message = str(exception)
        return JsonResponse(
            ResponseHandler.error_response(
                request_id,
                error_obj,
                -32603,
                error_message
            ),
            status=400
        )

    @staticmethod
    def handle_method_not_allowed():
        return handle_error(
            ErrorMessages.ERROR_METHOD_NOT_ALLOWED,
            response=ResponseHandler.method_not_allowed()
        )

    @staticmethod
    def handle_internal_error(request_id, exception, error_obj):
        return ResponseHandler.internal_error(request_id, error_obj, str(exception))