import numpy as np
import logging
from calculation_methods.py_calculations import calculation_utils as utils
from calculation_methods.py_calculations.error_handler.error_messages import ErrorMessages
from calculation_methods.py_calculations.calculation_factory import CalculationFactory

log = logging.getLogger('django')

class SampleTypeStatistics:
    # Calculator for statistical metrics
    def __init__(self, input_values=None, metrics=None):
        # Initialize with values and metrics
        self.input_values = np.array(input_values, dtype=float) if input_values else np.array([])
        self.metrics = metrics or []
        
        if self.input_values.size == 0:
            utils.handle_error(ErrorMessages.ERROR_MISSING_INPUT_DATA)
        
        self.strategies = {
            metric: CalculationFactory.create_statistical_calculation(metric)
            for metric in self.metrics
        }
    
    def calculate(self, metric):
        # Calculate a single statistical metric
        if metric not in self.strategies:
            utils.handle_error(ErrorMessages.ERROR_INVALID_DATA)
        return self.strategies[metric].calculate(self.input_values)

    def calculate_statistics(self):
        # Compute all requested metrics
        try:
            results = {}
            for metric, strategy in self.strategies.items():
                results[metric] = strategy.calculate(self.input_values)
            return results
        except Exception:
            utils.handle_error(ErrorMessages.ERROR_STATISTICAL_CALCULATION)
            return None