"""
conftest.py - Shared Fixtures and Configurations for Pytest

This file defines reusable fixtures, hooks, and configurations 
that are automatically available to all test files in the project. 
It helps avoid duplicate setup code and keeps tests clean and organized.
"""

import os
import sys

# Get the absolute path of the project root
project_root = os.path.abspath(os.path.join(os.path.dirname(__file__), '..'))
sys.path.insert(0, project_root)

# Ensure the calculation directory is also in the path
calculation_dir = os.path.join(project_root, 'calculation')
sys.path.insert(0, calculation_dir)