

# Running Unit Tests with Pytest

This document explains how to run unit tests using Pytest, generate a code coverage report, and view the results in an HTML format.

## Manually Running Tests  
To manually run the tests using Visual Studio Code, follow these steps:  

1. Navigate to the **Testing** icon in the left sidebar.  
2. Choose **pytest** as the test framework (used for PyReader).  
3. Set the **calculation** directory as the root directory.  
4. All available tests will be visible in the panel—click **Run All Tests** to execute them.  

## Running All Tests in a Single Command  
To run all unit tests in the project, you can use the `pytest` command. This command will automatically discover and execute all test files in the project.  

Run the following command in your terminal:  
```bash
pytest
```  
This will execute all test cases present in the project.

## Running Tests in a Specific Folder  
If you want to run only the tests inside a specific folder, you can specify the folder path when running the `pytest` command.  

For example, if you want to run only the tests inside the `py_tests` folder, use the following command:  
```bash
pytest py_tests/
```  
This ensures that only the tests within the specified folder are executed.

## Running a Code Coverage Report  
Code coverage helps in identifying how much of the code is executed by the test cases. To check code coverage while running tests, use the `--cov` flag followed by the module name.  


## Generating an HTML Code Coverage Report  
If you want to generate a detailed HTML report for code coverage, you can use the `--cov-report=html` flag.  

Run the following command to generate an HTML coverage report:  
```bash
pytest --cov=calculation --cov-report=html
```  
This command will create a folder named **htmlcov**, which contains an `index.html` file with a detailed coverage report.

## Viewing the HTML Coverage Report  
After generating the coverage report, you can open it in a web browser to analyze the results in a visual format.  

To open the report, use the following command based on your operating system:  

- **For Windows:**  
  ```bash
  start htmlcov/index.html
  ```  
- **For macOS:**  
  ```bash
  open htmlcov/index.html
  ```  
- **For Linux:**  
  ```bash
  xdg-open htmlcov/index.html
  ```  

This will open the coverage report in your default web browser.

Note:
## Running Tests Without Warnings  
Sometimes, warnings may appear while running tests, which can clutter the output. To suppress these warnings, you can use the `--disable-warnings` flag.  

Run the following command to execute tests without warnings:  
```bash
pytest --cov=calculation --cov-report=html --disable-warnings
```  
This ensures a cleaner test output while still generating the coverage report.


## Handling Import Errors Due to Cache Files  
If you encounter import errors due to `.pyc` or `__pycache__` files, it is recommended to delete these cached files before running the tests.  

Use the following command based on your operating system:  

- **For Linux/macOS:**  
  ```bash
  find . -name "*.pyc" -delete
  ```  
- **For Windows PowerShell:**  
  ```bash
  del /s /q *.pyc
  ```  
 Or remove the __pycache__ folders:
    pytest --cache-clear

This will remove any cached Python files, preventing potential conflicts during test execution.

---

Following these steps will help you efficiently run your tests, check code coverage, and analyze the results in a structured manner. 🚀

