import pytest
import numpy as np
from calculation.calculation_methods.py_calculations.cubic_spline import CubicSplineInterpolator
from calculation.py_tests.unit_test_utils import Utils  

@pytest.fixture
def sample_data():
    # Use Utils.generate_sample_data() to generate the sample data dynamically.
    return Utils.generate_sample_data()

class TestGenerateAdditionalTableBySampleGroups:

    @pytest.mark.happy_path
    def test_generate_table_with_valid_data(self, sample_data):
        """
        Test that the method correctly generates a table with valid input data from Utils.
        """
        # Arrange: Extract components from the sample_data fixture.
        input_data = sample_data["input_data"]
        standard_values = sample_data["standard_values"]
        blank_values = sample_data["blank_values"]

        # Act: Initialize interpolator and get the coefficients, which includes the additional table.
        interpolator = CubicSplineInterpolator(input_data, standard_values, blank_values)
        result = interpolator.get_coefficients()
        additional_table = result['Additional_Table_Details']

        # Assert: Verify the table length and sample identifiers match expected structure.
        # Assuming one entry per unique identifier, expect 8 unique identifiers (S1-S5, B, U1, U2).
        assert len(additional_table) == 8  # Adjusted based on Utils output: 5 standards + 1 blank + 2 unknowns
        assert additional_table[0]['identifier'] == 'S5'  # First standard should be S5
        assert additional_table[1]['identifier'] == 'S4'  # Second standard should be S4