import pytest
import numpy as np
from calculation.calculation_methods.py_calculations.cubic_spline import CubicSplineInterpolator
from calculation.py_tests.unit_test_utils import Utils  

@pytest.fixture
def sample_data():
    # Use Utils.generate_sample_data() to generate the sample data dynamically.
    return Utils.generate_sample_data()

class TestProcessAndGetAllValues:

    @pytest.mark.happy_path
    def test_process_and_get_all_values_with_valid_data(self, sample_data):
        #Test that process_and_get_all_values correctly processes valid input data from Utils.
        # Arrange: Extract components from the sample_data fixture.
        input_data = sample_data["input_data"]
        standard_values = sample_data["standard_values"]
        blank_values = sample_data["blank_values"]

        # Act: Initialize interpolator with the sample data.
        interpolator = CubicSplineInterpolator(input_data, standard_values, blank_values)
        
        # Assert: Verify that x_unique and y_unique are populated and spline is created.
        assert len(interpolator.x_unique) > 0
        assert len(interpolator.y_unique) > 0
        assert interpolator.spline is not None