import pytest
import numpy as np
import random
from calculation.calculation_methods.py_calculations.sample_statistics import SampleTypeStatistics
from calculation_methods.py_calculations.error_handler.error_messages import ErrorMessages
from calculation_methods.py_calculations.calculation_utils import handle_error


class TestCalculateMax:
    
    @pytest.mark.happy_path
    def test_calculate_max_normal_values(self):
        #Test calculate_max with a list of normal values.
        # Arrange
        input_values = random.sample(range(1, 100), 5)
        expected_result = max(input_values)
        stats = SampleTypeStatistics(input_values=input_values, metrics=['max'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["max"] == expected_result
        
    @pytest.mark.happy_path
    def test_calculate_max_with_nan(self):
        #Test calculate_max with NaN values in the list.
        # Arrange
        input_values = random.sample(range(1, 100), 4) + [np.nan]
        expected_result = max([x for x in input_values if not np.isnan(x)])
        stats = SampleTypeStatistics(input_values=input_values, metrics=['max'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["max"] == expected_result

    @pytest.mark.happy_path
    def test_calculate_max_all_nan(self):
        #Test calculate_max with all NaN values.
        # Arrange
        input_values = [np.nan] * 5
        stats = SampleTypeStatistics(input_values=input_values, metrics=['max'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert np.isnan(result["max"])

    @pytest.mark.edge_case
    def test_calculate_max_single_value(self):
        #Test calculate_max with a single value.
        # Arrange
        input_values = [random.randint(1, 100)]
        expected_result = input_values[0]
        stats = SampleTypeStatistics(input_values=input_values, metrics=['max'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["max"] == expected_result

    @pytest.mark.edge_case
    def test_calculate_max_large_numbers(self):
        #Test calculate_max with very large numbers.
        # Arrange
        input_values = [random.uniform(1e307, 1e308) for _ in range(3)]
        expected_result = max(input_values)
        stats = SampleTypeStatistics(input_values=input_values, metrics=['max'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["max"] == expected_result

    @pytest.mark.edge_case
    def test_calculate_max_negative_numbers(self):
        #Test calculate_max with negative numbers.
        # Arrange
        input_values = [random.randint(-100, -1) for _ in range(5)]
        expected_result = max(input_values)
        stats = SampleTypeStatistics(input_values=input_values, metrics=['max'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["max"] == expected_result
