import pytest
import numpy as np
import random
from calculation.calculation_methods.py_calculations.sample_statistics import SampleTypeStatistics


class TestCalculateMedian:

    @pytest.mark.happy_path
    def test_calculate_median_odd_number_of_elements(self):
        # Test calculate_median with an odd number of elements.
        
        # Arrange
        values = random.sample(range(1, 100), 5)
        stats = SampleTypeStatistics(input_values=values,metrics=['median'])

        # Act: Compute the median
        result = stats.calculate_statistics()

        # Assert: Compare with numpy median ignoring NaN values
        assert result["median"] == np.nanmedian(values)

    @pytest.mark.happy_path
    def test_calculate_median_even_number_of_elements(self):
        # Test calculate_median with an even number of elements.
        
        # Arrange
        values = random.sample(range(1, 100), 4)
        stats = SampleTypeStatistics(input_values=values,metrics=['median'])

        # Act
        result = stats.calculate_statistics()

        # Assert
        assert result["median"] == np.nanmedian(values)

    @pytest.mark.happy_path
    def test_calculate_median_with_nan_values(self):
        # Test calculate_median with NaN values in the list.
        
        # Arrange: Generate values and insert NaNs
        values = random.sample(range(1, 100), 3) + [np.nan, np.nan]
        stats = SampleTypeStatistics(input_values=values,metrics=['median'])

        # Act
        result = stats.calculate_statistics()

        # Assert
        assert result["median"] == np.nanmedian(values)

    @pytest.mark.edge_case
    def test_calculate_median_single_element(self):
        # Test calculate_median with a single element.
        
        # Arrange: Single random element
        values = [random.randint(1, 100)]
        stats = SampleTypeStatistics(input_values=values,metrics=['median'])

        # Act
        result = stats.calculate_statistics()

        # Assert
        assert result["median"] == values[0]

    @pytest.mark.edge_case
    def test_calculate_median_identical_elements(self):
        # Test calculate_median with all identical elements.
        
        # Arrange: Generate a list of identical random values
        value = random.randint(1, 100)
        values = [value] * 5
        stats = SampleTypeStatistics(input_values=values,metrics=['median'])

        # Act
        result = stats.calculate_statistics()

        # Assert
        assert result["median"] == value

    @pytest.mark.edge_case
    def test_calculate_median_large_numbers(self):
        # Test calculate_median with very large numbers.
        
        # Arrange
        values = sorted([random.uniform(1e10, 1e12) for _ in range(3)])
        stats = SampleTypeStatistics(input_values=values,metrics=['median'])

        # Act
        result = stats.calculate_statistics()

        # Assert
        assert result["median"] == np.nanmedian(values)

    @pytest.mark.edge_case
    def test_calculate_median_negative_numbers(self):
        # Test calculate_median with negative numbers.
        
        # Arrange
        values = sorted(random.sample(range(-100, -1), 3))
        stats = SampleTypeStatistics(input_values=values,metrics=['median'])

        # Act
        result = stats.calculate_statistics()

        # Assert
        assert result["median"] == np.nanmedian(values)
