import pytest
import numpy as np
import random
from calculation.calculation_methods.py_calculations.sample_statistics import SampleTypeStatistics
from calculation_methods.py_calculations.error_handler.error_messages import ErrorMessages
from calculation_methods.py_calculations.calculation_utils import handle_error


class TestCalculateSum:
    
    @pytest.mark.happy_path
    def test_calculate_sum_with_positive_numbers(self):
        # Test calculate_sum with a list of positive numbers
        input_values = [random.randint(1, 100) for _ in range(5)]
        expected_sum = sum(input_values)
        
        # Arrange
        stats = SampleTypeStatistics(input_values=input_values, metrics=['sum'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["sum"] == expected_sum

    @pytest.mark.happy_path
    def test_calculate_sum_with_negative_numbers(self):
        # Test calculate_sum with a list of negative numbers
        input_values = [random.randint(-100, -1) for _ in range(5)]
        expected_sum = sum(input_values)
        
        # Arrange
        stats = SampleTypeStatistics(input_values=input_values, metrics=['sum'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["sum"] == expected_sum

    @pytest.mark.happy_path
    def test_calculate_sum_with_mixed_numbers(self):
        # Test calculate_sum with a list of mixed positive and negative numbers
        input_values = [random.randint(-50, 50) for _ in range(5)]
        expected_sum = sum(input_values)
        
        # Arrange
        stats = SampleTypeStatistics(input_values=input_values, metrics=['sum'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["sum"] == expected_sum

    @pytest.mark.happy_path
    def test_calculate_sum_with_zeros(self):
        # Test calculate_sum with a list containing zeros
        input_values = [0] * 5
        expected_sum = sum(input_values)
        
        # Arrange
        stats = SampleTypeStatistics(input_values=input_values, metrics=['sum'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["sum"] == expected_sum
    @pytest.mark.edge_case
    def test_calculate_sum_with_nan_values(self):
        # Test calculate_sum with a list containing NaN values
        input_values = [random.randint(1, 10), np.nan, random.randint(1, 10), np.nan, random.randint(1, 10)]
        expected_sum = sum([x for x in input_values if not np.isnan(x)])
        
        # Arrange
        stats = SampleTypeStatistics(input_values=input_values, metrics=['sum'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["sum"] == expected_sum

    @pytest.mark.edge_case
    def test_calculate_sum_with_large_numbers(self):
        # Test calculate_sum with a list of large numbers
        large_number = random.uniform(1e15, 1e18)
        input_values = [large_number, large_number]
        expected_sum = sum(input_values)
        
        # Arrange
        stats = SampleTypeStatistics(input_values=input_values, metrics=['sum'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["sum"] == expected_sum

    @pytest.mark.edge_case
    def test_calculate_sum_with_single_value(self):
        # Test calculate_sum with a single value in the list
        input_values = [random.randint(1, 100)]
        expected_sum = sum(input_values)
        
        # Arrange
        stats = SampleTypeStatistics(input_values=input_values, metrics=['sum'])
        
        # Act
        result = stats.calculate_statistics()
        
        # Assert
        assert result["sum"] == expected_sum
