import numpy as np

class Utils:
    @staticmethod
    def generate_sample_data(rows=4, cols=6, std_concentrations=[6.25, 12.5, 25, 50, 100]):
        row_labels = [chr(65 + i) for i in range(rows)]

        # Generate standards (S1-S5)
        standards = [
            {"coordinates": f"{r}{c+1}", "identifier": f"S{len(std_concentrations)-c}", "x": [std_concentrations[c]], 
             "y": [np.random.uniform(60 + c * 100, 80 + c * 120)]}
            for r in row_labels[:-1] for c in range(len(std_concentrations))
        ]

        # Generate blanks (B)
        blank_values = [{"coordinates": f"{r}6", "identifier": "B", "x": [], "y": [np.random.uniform(8, 12)]} for r in row_labels]
        blank_values.append({"coordinates": f"{row_labels[-1]}5", "identifier": "B", "x": [], "y": [np.random.uniform(8, 12)]})

        # Generate unknowns (U1, U2)
        unknowns = [{"coordinates": f"D{i+1}", "identifier": f"U{1 + i//2}", "x": [], 
                     "y": [np.random.uniform(400 - i * 110, 450 - i * 140)]} 
                    for i in range(min(4, cols - 2))]

        return {
            "input_data": standards + blank_values + unknowns,
            "standard_values": standards,
            "blank_values": blank_values,
            "weighted": False,
            "forced_to_zero": False
        }
